clear
close all
clc
set(0,'defaultTextInterpreter','latex'); %trying to set the default
set(0,'defaultLegendInterpreter','latex'); %trying to set the default
%% Control panel
shift15 = 6; % [um]
shift30 = 11; % [um]
shift30_bis = 8; % [um]
shift53 = 11; % [um]
shift53_bis = 8; % [um]
shift_sims = 9.5;
graph_vals = [1 3 6];

%% Import data
files = dir('*.mat');
T = readtable("Data_filtered.xlsx");
T11 = table2array(T(2:end,1:3));
T15 = table2array(T(2:end,end-2:end));
T30 = table2array(T(2:end,5:8));
T53 = table2array(T(2:end,10:13));

%% Plots
legend_vec = cell(1,length(graph_vals));

figure
hold on
for i_case = 1:length(graph_vals)
i = graph_vals(i_case);
name_str = files(i).name;
load(name_str)
plot(w_TB_rpm,h_TB-shift_sims)
pos = strfind(name_str,'_');
pos_N = strfind(name_str,'N');
legend_vec{i_case} = name_str(pos(2)+1:pos_N);
end
grid on
xlabel('Angular Speed $\omega$ (krpm)')
ylabel('Minimum film thickness $h$ ($\mu m$)')
title('Tapered Bearing')
legend(legend_vec,'Location','northwest')

marker_vec = {'o';'square';'^';'diamond'};

for i = 1:size(T15,2)
plot(T15(1:2:end,i)*1e-3,T15(2:2:end,i)+shift15,'r',"Marker",marker_vec{i},'HandleVisibility','off')
end
x = T15(1:2:end,i)*1e-3;
y = T15(2:2:end,i)+shift15;
y_14 = y+14;


% for i = 1:size(T30,2)-1
% plot(T30(1:2:end,i)*1e-3,T30(2:2:end,i)+shift30_bis,'k',"Marker",marker_vec{i})
% plot(T53(1:2:end,i)*1e-3,T53(2:2:end,i)+shift53_bis,'b',"Marker",marker_vec{i})
% end

i = 4;
% x = T53(1:2:end,i)*1e-3;
% y = T53(2:2:end,i)+shift30;
% y_14 = y+14;
plot(T30(1:2:end,i)*1e-3,T30(2:2:end,i)+shift30,'k',"Marker",marker_vec{i},'HandleVisibility','off')
plot(T53(1:2:end,i)*1e-3,T53(2:2:end,i)+shift53,'b',"Marker",marker_vec{i},'HandleVisibility','off')





